unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,Dialogs,
  Menus, StdCtrls, ScktComp,WinSpool, ShellAPI, ExtCtrls;

(*
    LKBSDK.DLL external function Define.
*)
function LK_OpenPrinter( PrinterName:String ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-2	:	Printer Open Fail
	-3	:	Can't get DEVMODE's size
	-4	:	Insufficient internal memory available
	-5	:	Can't get DEVMODE
	-6	:	Upgrade SEWOO Label Printer Driver(V2.40 high)
*)
function LK_ClosePrinter( ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
*)
function LK_StartPage( ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
*)
function LK_EndPage( ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
*)
function LK_SetupPrinter(
        LabelWidth:String;  // 10 ~ 104 (Unit is mm)
        LabelLength:String; // 5 ~ 350 (Unit is mm)
        MediaType:integer;  // 0=Label with Gap, 1=Label width Black Mark
        GapHeight:String;   // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
        Offset:String;      // distance from Gap/BlackMark to perforation>. (Unit is mm)
        Density:integer;    // 0 ~ 15
        Speed:integer;      // 2 ~ 6 (Unit is Inch)
        Copies:integer      // 1 ~ 9999
        ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Invalid LabelWidth
	-2	:	Invalid LabelLength
	-3	:	Invalid MediaType
	-4	:	Invalid GapHeight
	-5	:	Invalid Offset
	-6	:	Invalid Density
	-7	:	Invalid Speed
	-8	:	Can't set/get DEVMODE
	-9	:	Can't make device context
	-10 :	Printer is not opened
*)
function LK_PrintWindowsFont(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Degree:integer;		  // 0,90,180,270
				Height:integer;		  // TTF size (Unit is Dot)
				Weight:integer;		  // 0=Normal, 1=Bold
				Italic:integer;		  // 0=Normal, 1=Italic
				Underline:integer;	// 0=Normal, 1=Underline
				TypeFace:String;	  // ex> "Arial"
				Data:String		      // text to be printed
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintBMP(
			  PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				FileName:String	    // BMP file name(incluing full path)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	File open error
	-2	:	File read error
	-3	:	Not BMP file
	-4	:	SetupPrinter() is not called
*)
function LK_PrintPCX(
			  PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				FileName:String	    // BMP file name(incluing full path)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	File open error
	-2	:	File read error
	-3	:	Not BMP file
	-4	:	SetupPrinter() is not called
*)
function LK_PrintDeviceFont(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Rotation:integer;	  // 0,90,180,270
				FontNumber:integer;	// 1,2,3,4,5,8 (8=option Korean Font)
				HorExpand:integer;	// 1 ~ 8
				VerExpand:integer;	// 1 ~ 9
				Reverse:integer;	  // 0=Normal, 1=Reverse
				Data:String		      // Data String
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintBarCode(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Rotation:integer;	  // 0,90,180,270
				BarCode:String;	    // type of Barcode	(Refer to LK-B10/20 Technical manual)
				NarrowWidth:integer;// available 1 ~ 10 (Refer to LK-B10/20 Technical manual)
				WideWidth:integer;	// available 2 ~ 30	(Refer to LK-B10/20 Technical manual)
				BarHeight:integer;	// Height of Barcode (Unit is Dot)
				Readable:integer;	  // 0='N', 1='B'
				lpszStr:String		  // Barcode content
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintLine(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				HoriSize:integer;	  // Horizontal size (Unit is Dot)
				VertSize:integer	  // Verticak size (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintDiagonalLine(
				StartX:integer;		  // Start X position (Unit is Dot)
				StartY:integer;		  // Start Y position (Unit is Dot)
				EndX:integer;		    // End X position (Unit is Dot)
				EndY:integer;		    // End Y position (Unit is Dot)
				Thick:integer		    // Line thick (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintBox(
				StartX:integer;		  // Start X position (Unit is Dot)
				StartY:integer;		  // Start Y position (Unit is Dot)
				EndX:integer;		    // End X position (Unit is Dot)
				EndY:integer;		    // End Y position (Unit is Dot)
				Thick:integer		    // Line thick (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintDate(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Degree:integer;		  // 0,90,180,270
				Height:integer;		  // TTF size (Unit is Dot)
				Weight:integer;		  // 0=Normal, 1=Bold
				Italic:integer;		  // 0=Normal, 1=Italic
				Underline:integer;	// 0=Normal, 1=Underline
				TypeFace:String;	  // ex> "Arial"
				DateFormat:integer	// 0=MM/DD/YY,1=DD/MM/YY,2=YY/mm/DD,3=MM/DD/YYYY,4=DD/MM/YYYY,5=YYYY/mm/DD
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintTime(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Degree:integer;		  // 0,90,180,270
				Height:integer;		  // TTF size (Unit is Dot)
				Weight:integer;		  // 0=Normal, 1=Bold
				Italic:integer;		  // 0=Normal, 1=Italic
				Underline:integer;	// 0=Normal, 1=Underline
				TypeFace:String;	  // ex> "Arial"
				TimeFormat:integer	// 0=HH:MM,1=HH:MM:SS,2=HH/MM AM(PM),3=HH/MM/SS AM(PM)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_SetupPrinterCutter(
        LabelWidth:String;  // 10 ~ 104 (Unit is mm)
        LabelLength:String; // 5 ~ 350 (Unit is mm)
        MediaType:integer;  // 0=Label with Gap, 1=Label width Black Mark
        GapHeight:String;   // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
        Offset:String;      // distance from Gap/BlackMark to perforation>. (Unit is mm)
        Density:integer;    // 0 ~ 15
        Speed:integer;      // 2 ~ 6 (Unit is Inch)
        Copies:integer;      // 1 ~ 9999
        Rotation:integer;      // 0 ~ 1 (0=normal, 1=rotate 180-degree)
        Cutting:integer;      // 0 ~ 2 (0=none, 1=Tear Bar, 2=Cut)
        CutMethod:integer;      // 0 ~ 3
        CutPageInterval:integer;      // 1 ~ 9999 (Cut interval)
        FeedAfterCut:String  // 12.5 ~ 14.0 (Unit is mm)
        ):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Invalid LabelWidth
	-2	:	Invalid LabelLength
	-3	:	Invalid MediaType
	-4	:	Invalid GapHeight
	-5	:	Invalid Offset
	-6	:	Invalid Density
	-7	:	Invalid Speed
	-8	:	Can't set/get DEVMODE
	-9	:	Can't make device context
	-10 :	Printer is not opened
*)
function LK_DrawLine(
				LineType:integer;		    // Line Pen Type
				sx:integer;		    // Start X position (Unit is Dot)
				sy:integer;		    // Start Y position (Unit is Dot)
				ex:integer;	  // End X position (Unit is Dot)
				ey:integer;	  // End Y position (Unit is Dot)
				Thick:integer	  // Thick size (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_Rectangle(
				LineType:integer;		    // Line Pen Type
				sx:integer;		    // Start X position (Unit is Dot)
				sy:integer;		    // Start Y position (Unit is Dot)
				ex:integer;	  // End X position (Unit is Dot)
				ey:integer;	  // End Y position (Unit is Dot)
				Thick:integer	  // Thick size (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_Ellipse(
				LineType:integer;		    // Line Pen Type
				sx:integer;		    // Start X position (Unit is Dot)
				sy:integer;		    // Start Y position (Unit is Dot)
				ex:integer;	  // End X position (Unit is Dot)
				ey:integer;	  // End Y position (Unit is Dot)
				Thick:integer	  // Thick size (Unit is Dot)
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintWindowsFontAlign(
				Alignment:integer;		    // Alignment (0=Left, 1=Center, 2=Right)
				PosY:integer;		    // Y position (Unit is Dot)
				Degree:integer;		  // 0,90,180,270
				Height:integer;		  // TTF size (Unit is Dot)
				Weight:integer;		  // 0=Normal, 1=Bold
				Italic:integer;		  // 0=Normal, 1=Italic
				Underline:integer;	// 0=Normal, 1=Underline
				TypeFace:String;	  // ex> "Arial"
				Data:String		      // text to be printed
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)
function LK_PrintWindowsFontPitch(
				PosX:integer;		    // X position (Unit is Dot)
				PosY:integer;		    // Y position (Unit is Dot)
				Degree:integer;		  // 0,90,180,270
				Height:integer;		  // TTF Height size (Unit is Dot)
				Width:integer;		  // TTF Width size (Unit is Dot)
				Weight:integer;		  // 0=Normal, 1=Bold
				Italic:integer;		  // 0=Normal, 1=Italic
				Underline:integer;	// 0=Normal, 1=Underline
				TypeFace:String;	  // ex> 'Arial'
				Data:String		      // text to be printed
				):integer; stdcall; external 'LKBSDK.dll';
(* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*)

procedure PrintWindowsFont(var sParam : string);
procedure PrintBMP(var sParam : string);
procedure PrintPCX(var sParam : string);
procedure PrintDeviceFont(var sParam : string);
procedure PrintBarCode(var sParam : string);
procedure PrintLine(var sParam : string);
procedure PrintDate(var sParam : string);
procedure PrintTime(var sParam : string);

const
  LK_SUCCESS = 0;
  MEDIA_TYPE = 0; // 0=Label with Gap, 1=Label width Black Mark

implementation

procedure PrintWindowsFont(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  nHeight:integer;
  nWidth:integer;
begin

  OutputDebugString('+++++ PrintWindowsFont() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;

  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();
		nHeight:=31;
		x:=80;
		y:=160;
		LK_PrintWindowsFont(x,y,0,nHeight,0,0,0,'Arial','Korea Mountain & River'); y := y + 70;
		LK_PrintWindowsFont(x,y,0,nHeight,1,0,0,'Arial','Korea Mountain & River'); y := y + 70;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,0,'Arial','Korea Mountain & River'); y := y+70;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,0,'Arial','Korea Mountain & River'); y := y+70;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,1,'Arial','Korea Mountain & River'); y := y+70;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,1,'Arial','Korea Mountain & River'); y := y+70;

		nWidth:=24;
		LK_PrintWindowsFontPitch(x,y,0,nHeight,nWidth,1,1,1,'Arial','Korea Mountain & River'); y := y+70;
	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintWindowsFont() -----');
end;

procedure PrintBMP(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  nHeight:integer;
begin

  OutputDebugString('+++++ PrintBMP() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

	  x:=10*8;
	  y:=10*8;
		LK_PrintBMP(x,y,'Red.bmp');

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintBMP() -----');
end;

procedure PrintPCX(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  nHeight:integer;
begin

  OutputDebugString('+++++ PrintPCX() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

	  x:=10*8;
	  y:=10*8;
		LK_PrintPCX(x,y,'Ring.pcx');

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintPCX() -----');
end;

procedure PrintDeviceFont(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  nHeight:integer;
begin

  OutputDebugString('+++++ PrintDeviceFont() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

		x:=50*8;
		y:=50*8;
		// 0 degree
		LK_PrintDeviceFont(x,y,0,3,1,1,0,sParam);
		// 90 degree
		LK_PrintDeviceFont(x,y,90,3,1,1,0,sParam);
		// 180 degree
		LK_PrintDeviceFont(x,y,180,3,1,1,0,sParam);
		// 270 degree
		LK_PrintDeviceFont(x,y,270,3,1,1,0,sParam);
		// reverse
		x:=10*8;
		y:=90*8;
		LK_PrintDeviceFont(x,y,0,3,2,2,1,sParam);
		// reverse
		y:=100*8;
		LK_PrintDeviceFont(x,y,0,1,1,1,0,sParam);
		y:=y + 5*8;
		LK_PrintDeviceFont(x,y,0,2,1,1,0,sParam);
		y:=y + 6*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,sParam);
		y:=y + 7*8;
		LK_PrintDeviceFont(x,y,0,4,1,1,0,sParam);
		y:=y + 8*8;
		LK_PrintDeviceFont(x,y,0,5,1,1,0,'SEWOO TECH');

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintDeviceFont() -----');
end;
(*
			>>>> Barcode Spec. for EPL2 <<<<

+------+--------------------------------------------------+------------------+
| Bar  |                Description                       | Narrow bar width |
| Code |                                                  |  width in dots   |
+------+--------------------------------------------------+------------------+
|  3   |Code 39 std. or extended                          |     1 ~ 10       |
|  3C  |Code 39 with check digit                          |     1 ~ 10       |
|  93  |Code 93                                           |     1 ~ 10       |
|  0   |Code 128 UCC Serial Shipping Container Code       |     1 ~ 10       |
|  1   |Code 128 auto A, B, C modes                       |     1 ~ 10       |
|  1A  |Code 128 mode A                                   |     1 ~ 10       |
|  1B  |Code 128 mode B                                   |     1 ~ 10       |
|  1C  |Code 128 mode C                                   |     1 ~ 10       |
|  K   |Codabar                                           |     1 ~ 10       |
|  E80 |EAN8                                              |     2 ~ 4        |
|  E82 |EAN8 2 digit add-on                               |     2 ~ 4        |
|  E85 |EAN8 5 digit add-on                               |     2 ~ 4        |
|  E30 |EAN13                                             |     2 ~ 4        |
|  E32 |EAN13 2 digit add-on                              |     2 ~ 4        |
|  E35 |EAN13 5 digit add-on                              |     2 ~ 4        |
|  2G  |German Post Code                                  |     3 ~ 4        |
|  2   |Interleaved 2 of 5                                |     1 ~ 10       |
|  2C  |Interleaved 2 of 5 with mod 10 check digit        |     1 ~ 10       |
|  2D  |Interleaved 2 of 5 with human readable check digit|     1 ~ 10       |
|  P   |Postnet 5, 9, 11 & 13 digit                       |       __         |
|  PL  |Planet 11 & 13 digit                              |       __         |
|  J   |Japanese Postnet                                  |       __         |
|  1E  |UCC/EAN 128                                       |     1 ~ 10       |
|  UA0 |UPC A                                             |     2 ~ 4        |
|  UA2 |UPC A 2 digit add-on                              |     2 ~ 4        |
|  UA5 |UPC A 5 digit add-on                              |     2 ~ 4        |
|  UE0 |UPC E                                             |     2 ~ 4        |
|  UE2 |UPC E 2 digit add-on                              |     2 ~ 4        |
|  UE5 |UPC E 5 digit add-on                              |     2 ~ 4        |
|  2U  |UPC Interleaved 2 of 5                            |     1 ~ 10       |
|  L   |Plessey (MSI-1) with mod. 10 check digit          |       __         |
|  M   |MSI-3 with mod. 10 check digit                    |       __         |
+------+--------------------------------------------------+------------------+
*)

procedure PrintBarCode(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  BarHeight:integer;
begin

  OutputDebugString('+++++ PrintBarCode() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

		BarHeight:=12*8;	// 12mm
		x:=10*8;
		y:=10*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,'Code 39 Barcode');
		// 0 degree
		x:=50*8;
		y:=60*8;
		LK_PrintBarCode(x,y,0,'3',2,4,BarHeight,1,'1234567890');
		// 90 degree
		x:=50*8-2*8;
		y:=60*8;
		LK_PrintBarCode(x,y,90,'3',2,4,BarHeight,1,'1234567890');
		// 180 degree
		x:=50*8-2*8;
		y:=60*8-2*8;
		LK_PrintBarCode(x,y,180,'3',2,4,BarHeight,1,'1234567890');
		// 270 degree
		x:=50*8;
		y:=60*8-2*8;
		LK_PrintBarCode(x,y,270,'3',2,4,BarHeight,1,'1234567890');

		// 0 degree, No readable
		x:=10*8;
		y:=115*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,'Human readable=No');
		y:=120*8;
		LK_PrintBarCode(x,y,0,'3',2,4,BarHeight,0,'1234567890');

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintBarCode() -----');
end;

procedure PrintLine(var sParam : string);
var
  rtn:integer;
  x,y:integer;
  nHeight:integer;
begin

  OutputDebugString('+++++ PrintLine() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

		x:=10*8;
		y:=10*8;
		LK_PrintLine(x,y,50*8,2*8);

		x:=10*8;
		y:=15*8;
		LK_DrawLine(PS_SOLID, x,y,x+50*8, y, 16);

		x:=10*8;
		y:=20*8;
		LK_PrintDiagonalLine(x,y,x+50*8,y+30*8,2*8);

		x:=20*8;
		y:=20*8;
		LK_DrawLine(PS_SOLID, x,y,x+50*8,y+30*8, 16);

		x:=30*8;
		y:=20*8;
		LK_DrawLine(PS_DASH, x,y,x+50*8,y+30*8, 4);

		x:=40*8;
		y:=20*8;
		LK_DrawLine(PS_DOT, x,y,x+50*8,y+30*8, 4);

		x:=50*8;
		y:=20*8;
		LK_DrawLine(PS_DASHDOT, x,y,x+50*8,y+30*8, 4);

		x:=60*8;
		y:=20*8;
		LK_DrawLine(PS_DASHDOTDOT, x,y,x+30*8,y+18*8, 4);

		x:=70*8;
		y:=20*8;
		LK_DrawLine(PS_DASH, x,y,x+20*8,y, 4);


		x:=10*8;
		y:=60*8;
		LK_Rectangle(PS_DOT, x, y, x+50*8, y+20*8, 4);
		x:=70*8;
		y:=60*8;
		LK_Rectangle(PS_SOLID, x, y, x+20*8, y+4, 4);
		x:=10*8;
		y:=90*8;
		LK_Ellipse(PS_DOT, x, y, x+30*8, y+30*8, 4);

		x:=40*8;
		y:=90*8;
		LK_DrawLine(PS_DASH, x,y,x+30*8,y+30*8, 4);
		x:=50*8;
		y:=90*8;
		LK_DrawLine(PS_DOT, x,y,x+30*8,y+30*8, 4);
		x:=60*8;
		y:=90*8;
		LK_DrawLine(PS_DASHDOT, x,y,x+30*8,y+30*8, 4);

		nHeight:=56;
		x:=50*8;
		y:=52*8;
    // Center Align Test
		LK_PrintWindowsFontAlign(1,y,0,nHeight,0,0,0,'Arial','Korea Mountain & River'); // Center Align
(*
		x:=10*8;
		y:=60*8;
		LK_PrintBox(x,y,x+50*8,y+30*8,2*8);
*)
	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintLine() -----');
end;

procedure PrintDate(var sParam : string);
var
  rtn:integer;
  x,y:integer;
begin

  OutputDebugString('+++++ PrintDate() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

		x:=50*8;
		y:=50*8;
		// 0 degree
		LK_PrintDate(x,y,0,3*8,0,0,0,'Arial',0); // 0=MM/DD/YY
		// 90 degree
		LK_PrintDate(x,y,90,3*8,0,0,0,'Arial',0); // 0=MM/DD/YY
		// 180 degree
		LK_PrintDate(x,y,180,3*8,0,0,0,'Arial',0); // 0=MM/DD/YY
		// 270 degree
		LK_PrintDate(x,y,270,3*8,0,0,0,'Arial',0); // 0=MM/DD/YY

		x:=50*8;
		y:=80*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',0); y:=y+5*8;  // 0=MM/DD/YY
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',1); y:=y+5*8;  // 1=DD/MM/YY
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',2); y:=y+5*8;  // 2=YY/mm/DD
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',3); y:=y+5*8;  // 3=MM/DD/YYYY
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',4); y:=y+5*8;  // 4=DD/MM/YYYY
		LK_PrintDate(x,y,0,4*8,0,0,0,'Arial',5); y:=y+5*8;  // 5=YYYY/mm/DD

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintDate() -----');
end;
procedure PrintTime(var sParam : string);
var
  rtn:integer;
  x,y:integer;
begin

  OutputDebugString('+++++ PrintTime() +++++');
  if ( LK_OpenPrinter(sParam) <> LK_SUCCESS ) then
  begin
    Exit;
  end;
  rtn := LK_SetupPrinter(
            '104.0',    // 10~104 (Unit is mm)
            '152.4',    // 5~350 (Unit is mm)
            MEDIA_TYPE, // 0=Label with Gap, 1=Label width Black Mark
            '3.0',      // if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
            '0',        // if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
            8,          // Density : 0 ~ 15
            6,          // Print Speed : 2 ~ 6 (Unit is Inch)
            1           // Multi-Copies : 1 ~ 9999
          );
  if ( rtn <> LK_SUCCESS ) then
  begin
    LK_ClosePrinter();
    Exit;
  end;

	LK_StartPage();

		x:=50*8;
		y:=50*8;
		// 0 degree
		LK_PrintTime(x,y,0,3*8,0,0,0,'Arial',1); // 1=HH:MM:SS
		// 90 degree
		LK_PrintTime(x,y,90,3*8,0,0,0,'Arial',1); // 1=HH:MM:SS
		// 180 degree
		LK_PrintTime(x,y,180,3*8,0,0,0,'Arial',1); // 1=HH:MM:SS
		// 270 degree
		LK_PrintTime(x,y,270,3*8,0,0,0,'Arial',1); // 1=HH:MM:SS

		x:=50*8;
		y:=80*8;
		LK_PrintTime(x,y,0,4*8,0,0,0,'Arial',0); y:=y+5*8;  // 0=HH:MM
		LK_PrintTime(x,y,0,4*8,0,0,0,'Arial',1); y:=y+5*8;  //
		LK_PrintTime(x,y,0,4*8,0,0,0,'Arial',2); y:=y+5*8;  // 2=HH/MM AM(PM)
		LK_PrintTime(x,y,0,4*8,0,0,0,'Arial',3); y:=y+5*8;  // 3=HH/MM/SS AM(PM)

	LK_EndPage();

  LK_ClosePrinter();

  OutputDebugString('----- PrintTime() -----');
end;

end.
